param($inst_para)

#write-host "input parameter: $inst_para"

$install_path="C:\Program Files (x86)\REALTEK\Realtek Bluetooth"

if ($inst_para -eq "inst")
{
    #write-host "install driver"
    $TRUE_FALSE=(Test-Path $install_path)
    if($TRUE_FALSE -eq "True")
    {
        Remove-Item -Recurse -Force $install_path
        #md $install_path
    }

    md $install_path
    #New-Item $install_path -type Directory

    Start-Sleep -s 1

    #Write-Host $install_path\*.inf
    #Write-Host $PSScriptRoot
    Copy-Item  $PSScriptRoot\x64\*.* $install_path
    Copy-Item  $PSScriptRoot\devcon.exe $install_path
    Copy-Item  $PSScriptRoot\script.ps1 $install_path
    Copy-Item  $PSScriptRoot\UninstallDriver.cmd $install_path
    pnputil /add-driver "$install_path\Rtkfilter.inf" /install >$install_path\pnp.log
	
	$device = Get-PnpDevice -Class bluetooth | Where-Object { $_.InstanceId -like "*VID_0BDA&PID_C822*" }
	$instanceId = $device.InstanceId
	$regPath = "HKLM:\SYSTEM\CurrentControlSet\Enum\$instanceId\Device Parameters\WDF"

	# 修改注册表
	if (-not (Test-Path "$regPath")) {
		New-Item -Path $regPath -Name "IdleInWorkingState" -Force
	}
	Set-ItemProperty -Path "$regPath" -Name "IdleInWorkingState" -Value 0 -Type DWord

	# 重启设备
	Disable-PnpDevice -InstanceId $device.InstanceId -Confirm:$false
	Enable-PnpDevice -InstanceId $device.InstanceId -Confirm:$false

	
}
elseif ($inst_para -eq "unin")
{
    #write-host "uninstall driver"

    $exepath=Join-Path $PSScriptRoot "devcon.exe"
    #Write-Host $exepath
    $RTKBTHWID=gwmi win32_PnPSignedDriver | where {$_.Manufacturer -like "*Realtek*" -and $_.DeviceClass  -eq "Bluetooth"}
    Write-Host $RTKBTHWID
    $delpara="remove"+ " " + $RTKBTHWID.HardWareID
    Write-Host $delpara

    $Filters=Get-WindowsDriver -Online | where {$_.ProviderName -like "*Realtek*" -and $_.ClassName -eq "Bluetooth"} 
    foreach ($filter in $Filters)
    {
        Write-Host "Deleting filter driver..."
        echo $filter
        pnputil /delete-driver $filter.Driver /force
    }    

    Start-Process $exepath -ArgumentList $delpara
    Start-Sleep -s 3
    Start-Process $exepath -ArgumentList "rescan"
       

    Remove-Item -Recurse -Force $install_path
}

else
{
    write-host "unkown para"
}
